import discord

from discord.ext import tasks, commands

import aiohttp

import asyncio
import time
import platform
from datetime import datetime
from zoneinfo import ZoneInfo

TOKEN = "MTQwNDI3MTgzMTk1ODk0OTk4MA.GbRGgc.lnpE9w5WkAHJ1V8VvlBoEJoPtDSbLsCRCg-9lc"

CHANNEL_ID = 1402428159651086477  # ID du salon Discord (sans guillemets)

# Catégories et services surveillés

categories = {

    "Infrastructure": [
        {"name": "Hébergement Web", "address": "https://web01.vibes-hosting.fr:8443"},
        {"name": "Hébergement Bot", "address": "https://panel.water-heberg.fr"},
        
    ],
    
   "Académie Vaulx-en-Velin": [
        {"name": "Site", "address": "https://ac-velin.fr"},
        {"name": "Ent", "address": "https://ent.ac-velin.fr"},
        {"name": "Mail", "address": "https://webmail.ac-velin.fr"},
        {"name": "Banque", "address": "https://banque.ac-velin.fr"},
        {"name": "Bot Académique", "address": "node.water-heberg.fr:10614"},
        {"name": "Bot Statut", "address": "node.water-heberg.fr:10649"},
       
    ],
    
     "Collège Charles De Gaulle": [
        {"name": "Site", "address": "https://clg-charles-de-gaulle.ac-velin.fr"},
        {"name": "Bot Établissement", "address": "node.water-heberg.fr:10596"},
        {"name": "Bot Statut", "address": "node.water-heberg.fr:10484"},
    ]
}

# Icônes de statut

STATUS_ICONS = {

    "ok": "<a:on:1404297615968964649>",

    "slow": "<a:attention:1404297678980124754>",

    "down": "<a:off:1404297749884567705>"

}

bot = commands.Bot(command_prefix="!", intents=discord.Intents.default())

message_to_edit = None

# Vérifie un site HTTP

async def check_http(url):

    timeout = aiohttp.ClientTimeout(total=5)

    headers = {"User-Agent": "Mozilla/5.0"}

    try:

        start = time.time()

        async with aiohttp.ClientSession(timeout=timeout, headers=headers) as session:

            async with session.get(url) as resp:

                if resp.status < 400:

                    return (time.time() - start) * 1000

        return None

    except:

        return None

# Vérifie un node TCP

async def check_tcp(host_port):

    start = time.time()

    try:

        host, port = host_port.split(":")

        port = int(port)

        reader, writer = await asyncio.wait_for(

            asyncio.open_connection(host, port),

            timeout=5

        )

        writer.close()

        await writer.wait_closed()

        return (time.time() - start) * 1000

    except:

        return None

# Détecte le type de test

async def get_status(address):

    if address.startswith("http://") or address.startswith("https://"):

        latency = await check_http(address)

    elif ":" in address:

        latency = await check_tcp(address)

    else:

        latency = None

    if latency is None:

        return STATUS_ICONS["down"], "Injoignable"

    elif latency > 1000:

        return STATUS_ICONS["slow"], f"{latency:.0f} ms"

    else:

        return STATUS_ICONS["ok"], f"{latency:.0f} ms"

# Construit l'embed Discord

async def build_status_embed():

    embed = discord.Embed(title="📡 Statut des services", color=0x2ECC71)

    for category, services in categories.items():

        lines = []

        for svc in services:

            emoji, latency_text = await get_status(svc["address"])

            lines.append(f"{emoji} • {svc['name']} : {latency_text}")

        embed.add_field(name=category, value="\n".join(lines), inline=False)

    legend = (

        f"{STATUS_ICONS['ok']} Joignable\n"

        f"{STATUS_ICONS['slow']} Ping > 1s\n"

        f"{STATUS_ICONS['down']} Injoignable"

    )

    embed.add_field(name="📖 Légende :", value=legend, inline=False)

    now = datetime.now(ZoneInfo("Europe/Paris")).strftime("%d/%m/%Y %H:%M")

    embed.set_footer(text=f"Dernière mise à jour : {now}")

    return embed

# Tâche automatique

@tasks.loop(minutes=1)

async def update_status():

    global message_to_edit

    channel = bot.get_channel(CHANNEL_ID)

    if channel is None:

        print(f"❌ Impossible de trouver le salon {CHANNEL_ID}")

        return

    embed = await build_status_embed()

    if message_to_edit is None:

        message_to_edit = await channel.send(embed=embed)

    else:

        await message_to_edit.edit(embed=embed)

# Commande manuelle

@bot.command()

async def status(ctx):

    global message_to_edit

    embed = await build_status_embed()

    if message_to_edit is None:

        message_to_edit = await ctx.send(embed=embed)

    else:

        await message_to_edit.edit(embed=embed)

        await ctx.send("✅ Statut mis à jour", delete_after=2)

# Démarrage

@bot.event

async def on_ready():

    print(f"✅ Bot connecté en tant que {bot.user}")

    await asyncio.sleep(2)

    update_status.start()

bot.run(TOKEN)