import discord

from discord.ext import commands

import asyncio

import os

import json

# Charger la configuration

with open("config.json") as f:

    config = json.load(f)

TOKEN = config["TOKEN"]

PREFIX = config.get("PREFIX", "+")  # Par défaut "+"

INTENTS = discord.Intents.default()

INTENTS.message_content = True

INTENTS.members = True

INTENTS.guilds = True

bot = commands.Bot(command_prefix=PREFIX, intents=INTENTS)

@bot.event

async def on_ready():

    print(f"✅ Bot connecté en tant que {bot.user}")

    try:

        synced = await bot.tree.sync()

        print(f"📌 Commandes slash synchronisées : {len(synced)}")

    except Exception as e:

        print(f"❌ Erreur sync commandes slash : {e}")

async def load_extensions():

    # Charger toutes les commandes

    for dossier in ["Commande", "Message automatique", "Fun"]:

        if os.path.exists(dossier):

            for file in os.listdir(dossier):

                if file.endswith(".py"):

                    try:

                        await bot.load_extension(f"{dossier}.{file[:-3]}")

                        print(f"✅ {file} chargé depuis {dossier}")

                    except Exception as e:

                        print(f"❌ Erreur chargement {file} : {e}")

async def main():

    async with bot:

        await load_extensions()

        await bot.start(TOKEN)

if __name__ == "__main__":

    asyncio.run(main())