import discord

from discord import app_commands

from discord.ext import commands

class SayCommand(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="say", description="Envoyer un message en texte brut")

    @app_commands.checks.has_permissions(manage_messages=True)

    async def say_command(self, interaction: discord.Interaction, message: str):

        await interaction.channel.send(message)

        await interaction.response.send_message("✅ Message envoyé.", ephemeral=True)

async def setup(bot):

    await bot.add_cog(SayCommand(bot))