import discord

from discord import app_commands

from discord.ext import commands

class MPCommand(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="mp", description="Envoyer un message privé à un utilisateur")

    @app_commands.checks.has_permissions(manage_messages=True)

    async def mp_command(self, interaction: discord.Interaction, membre: discord.Member, message: str):

        try:

            await membre.send(message)

            await interaction.response.send_message(f"✅ Message envoyé à {membre.mention}", ephemeral=True)

        except discord.Forbidden:

            await interaction.response.send_message(f"❌ Impossible d'envoyer un message à {membre.mention}.", ephemeral=True)

async def setup(bot):

    await bot.add_cog(MPCommand(bot))