import discord

from discord import app_commands

from discord.ext import commands

# Dictionnaire temporaire pour les avertissements (warns)

warns = {}

class Moderation(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    # 📌 BAN

    @app_commands.command(name="ban", description="Bannir un membre")

    @app_commands.checks.has_permissions(ban_members=True)

    async def ban(self, interaction: discord.Interaction, membre: discord.Member, raison: str):

        try:

            await membre.ban(reason=raison)

            await interaction.response.send_message(f"🔨 {membre} a été banni. Raison : {raison}")

        except discord.Forbidden:

            await interaction.response.send_message("❌ Je n'ai pas la permission de bannir cet utilisateur.")

    # 📌 KICK

    @app_commands.command(name="kick", description="Expulser un membre")

    @app_commands.checks.has_permissions(kick_members=True)

    async def kick(self, interaction: discord.Interaction, membre: discord.Member, raison: str):

        try:

            await membre.kick(reason=raison)

            await interaction.response.send_message(f"👢 {membre} a été expulsé. Raison : {raison}")

        except discord.Forbidden:

            await interaction.response.send_message("❌ Je n'ai pas la permission d'expulser cet utilisateur.")

    # 📌 CLEAR

    @app_commands.command(name="clear", description="Supprimer des messages")

    @app_commands.checks.has_permissions(manage_messages=True)

    async def clear(self, interaction: discord.Interaction, nombre: int):

        if nombre <= 0:

            await interaction.response.send_message("❌ Le nombre doit être supérieur à 0.", ephemeral=True)

            return

        await interaction.channel.purge(limit=nombre)

        await interaction.response.send_message(f"🗑️ {nombre} messages supprimés.", ephemeral=True)

    # 📌 WARN

    @app_commands.command(name="warn", description="Avertir un membre")

    @app_commands.checks.has_permissions(manage_messages=True)

    async def warn(self, interaction: discord.Interaction, membre: discord.Member, raison: str):

        if membre.id not in warns:

            warns[membre.id] = []

        warns[membre.id].append(raison)

        await interaction.response.send_message(f"⚠️ {membre.mention} a reçu un avertissement. Raison : {raison}")

    # 📌 UNWARN

    @app_commands.command(name="unwarn", description="Retirer un avertissement à un membre")

    @app_commands.checks.has_permissions(manage_messages=True)

    async def unwarn(self, interaction: discord.Interaction, membre: discord.Member, index: int):

        if membre.id in warns and 0 < index <= len(warns[membre.id]):

            removed = warns[membre.id].pop(index - 1)

            await interaction.response.send_message(f"✅ Avertissement retiré : {removed}")

        else:

            await interaction.response.send_message("❌ Aucun avertissement trouvé avec cet index.")

    # 📌 INFRACTIONS

    @app_commands.command(name="infractions", description="Voir les avertissements d'un membre")

    async def infractions(self, interaction: discord.Interaction, membre: discord.Member):

        if membre.id in warns and warns[membre.id]:

            embed = discord.Embed(title=f"⚠️ Infractions de {membre}", color=discord.Color.orange())

            for i, raison in enumerate(warns[membre.id], start=1):

                embed.add_field(name=f"Avertissement {i}", value=raison, inline=False)

            await interaction.response.send_message(embed=embed)

        else:

            await interaction.response.send_message(f"✅ {membre} n'a aucun avertissement.")

async def setup(bot):

    await bot.add_cog(Moderation(bot))