import discord

from discord import app_commands

from discord.ext import commands

import json

with open("config.json", "r") as f:

    config = json.load(f)

LIENS_UTILS = config["LIENS_UTILS"]

class LienCommand(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="lien", description="Afficher les liens utiles")

    async def lien_command(self, interaction: discord.Interaction):

        embed = discord.Embed(

            title="🔗 Liens Utiles",

            description="Voici les liens utiles de l'académie :",

            color=0x7B6AB2

        )

        for nom, url in LIENS_UTILS.items():

            embed.add_field(name=nom, value=f"[Cliquez ici]({url})", inline=False)

        await interaction.response.send_message(embed=embed)

async def setup(bot):

    await bot.add_cog(LienCommand(bot))