import discord

from discord import app_commands

from discord.ext import commands

import json

with open("config.json", "r") as f:

    config = json.load(f)

FOOTER_TEXT = config["FOOTER_TEXT"]

FOOTER_ICON = config["FOOTER_ICON"]

class EmbedCommand(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="embed", description="Envoyer un embed personnalisé")

    @app_commands.checks.has_permissions(manage_messages=True)

    async def embed_command(self, interaction: discord.Interaction, titre: str, description: str):

        embed = discord.Embed(

            title=titre,

            description=description,

            color=0x7B6AB2  # 🎨 Couleur fixe en violet clair

        )

        embed.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

        await interaction.channel.send(embed=embed)

        await interaction.response.send_message("✅ Embed envoyé.", ephemeral=True)

async def setup(bot):

    await bot.add_cog(EmbedCommand(bot))