import discord

from discord import app_commands

from discord.ext import commands

class CodeMail(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="code-mail", description="Envoyer un code de connexion en MP")

    @app_commands.checks.has_permissions(manage_messages=True)

    async def code_mail(self, interaction: discord.Interaction, cible: discord.Member, mail: str, mdp: str):

        try:

            await cible.send(

                f"📩 **Informations de connexion**\n\n"

                f"**E-mail :** `{mail}`\n"

                f"**Mot de passe :** `{mdp}`\n\n"

                f"Veuillez conserver ces informations en lieu sûr.\n"

                f"— Académie Vaulx-en-Velin"

            )

            await interaction.response.send_message(f"✅ Informations envoyées en MP à {cible.mention}", ephemeral=True)

        except discord.Forbidden:

            await interaction.response.send_message(f"❌ Impossible d'envoyer un MP à {cible.mention}", ephemeral=True)

async def setup(bot):

    await bot.add_cog(CodeMail(bot))