import discord

from discord.ext import commands

import json

import os

BLACKLIST_FILE = "blacklist.json"

def load_blacklist():

    if os.path.exists(BLACKLIST_FILE):

        with open(BLACKLIST_FILE, "r") as f:

            return json.load(f)

    return {}

def save_blacklist(data):

    with open(BLACKLIST_FILE, "w") as f:

        json.dump(data, f, indent=4)

class Blacklist(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

        self.blacklist = load_blacklist()

    @commands.command(name="bl")

    @commands.has_permissions(administrator=True)

    async def add_blacklist(self, ctx, user_id: int, *, reason: str):

        """Ajoute un utilisateur à la blacklist et le ban sur tous les serveurs"""

        self.blacklist[str(user_id)] = reason

        save_blacklist(self.blacklist)

        banned_count = 0

        for guild in self.bot.guilds:

            try:

                await guild.ban(discord.Object(id=user_id), reason=f"[Blacklist] {reason}")

                banned_count += 1

            except discord.Forbidden:

                pass

            except discord.HTTPException:

                pass

        # Message de confirmation

        await ctx.send(f"✅ Utilisateur `{user_id}` ajouté à la blacklist et banni de **{banned_count}** serveurs.")

        # Log dans le salon dédié

        log_channel_id = ctx.bot.config.get("BLACKLIST_LOG_CHANNEL_ID")

        if log_channel_id:

            log_channel = self.bot.get_channel(log_channel_id)

            if log_channel:

                await log_channel.send(

                    f"🔨 **Blacklist globale**\n"

                    f"👤 ID : `{user_id}`\n"

                    f"📝 Raison : {reason}\n"

                    f"👮 Staff : {ctx.author.mention}"

                )

    @commands.command(name="unbl")

    @commands.has_permissions(administrator=True)

    async def remove_blacklist(self, ctx, user_id: int):

        """Retire un utilisateur de la blacklist"""

        if str(user_id) in self.blacklist:

            del self.blacklist[str(user_id)]

            save_blacklist(self.blacklist)

            await ctx.send(f"✅ Utilisateur `{user_id}` retiré de la blacklist.")

        else:

            await ctx.send(f"❌ L'utilisateur `{user_id}` n'est pas dans la blacklist.")

    @commands.Cog.listener()

    async def on_member_join(self, member):

        """Ban automatique si l'utilisateur est blacklisté"""

        if str(member.id) in self.blacklist:

            reason = self.blacklist[str(member.id)]

            try:

                await member.ban(reason=f"[Blacklist auto] {reason}")

                log_channel_id = self.bot.config.get("BLACKLIST_LOG_CHANNEL_ID")

                if log_channel_id:

                    log_channel = self.bot.get_channel(log_channel_id)

                    if log_channel:

                        await log_channel.send(

                            f"🚫 **Bannissement automatique (Blacklist)**\n"

                            f"👤 {member} (`{member.id}`)\n"

                            f"📝 Raison : {reason}"

                        )

            except discord.Forbidden:

                pass

async def setup(bot):

    bot.config = load_config()

    await bot.add_cog(Blacklist(bot))

def load_config():

    if os.path.exists("config.json"):

        with open("config.json", "r") as f:

            return json.load(f)

    return {}