import discord

from discord.ext import commands

import asyncio

import os

import json

# Charger la config

with open("config.json") as f:

    config = json.load(f)

TOKEN = config["TOKEN"]

PREFIX = "+"

INTENTS = discord.Intents.default()

INTENTS.message_content = True

INTENTS.members = True

bot = commands.Bot(command_prefix=PREFIX, intents=INTENTS)

@bot.event

async def on_ready():

    print(f"✅ Connecté en tant que {bot.user}")

    try:

        synced = await bot.tree.sync()

        print(f"📌 Commandes slash synchronisées : {len(synced)}")

    except Exception as e:

        print(f"❌ Erreur lors de la sync des commandes slash : {e}")

async def load_extensions():

    # Charger les commandes classiques

    for file in os.listdir("Commande"):

        if file.endswith(".py"):

            try:

                await bot.load_extension(f"Commande.{file[:-3]}")

                print(f"✅ Commande chargée : {file}")

            except Exception as e:

                print(f"❌ Erreur chargement commande {file} : {e}")

    # Charger les messages automatiques

    for file in os.listdir("Message automatique"):

        if file.endswith(".py"):

            try:

                await bot.load_extension(f"Message automatique.{file[:-3]}")

                print(f"✅ Message auto chargé : {file}")

            except Exception as e:

                print(f"❌ Erreur chargement message auto {file} : {e}")

async def main():

    async with bot:

        await load_extensions()

        await bot.start(TOKEN)

if __name__ == "__main__":

    asyncio.run(main())