import discord

from discord import app_commands

from discord.ext import commands

import json

import io

with open("config.json", "r") as f:

    config = json.load(f)

TICKET_CATEGORY_ID = config["TICKET_CATEGORY_ID"]

TICKET_LOG_CHANNEL_ID = config["TICKET_LOG_CHANNEL_ID"]

class CloseTicketView(discord.ui.View):

    def __init__(self):

        super().__init__(timeout=None)

    @discord.ui.button(label="🔒 Fermer le ticket", style=discord.ButtonStyle.red)

    async def close_ticket(self, interaction: discord.Interaction, button: discord.ui.Button):

        if not interaction.user.guild_permissions.manage_channels:

            await interaction.response.send_message("❌ Vous n'avez pas la permission de fermer ce ticket.", ephemeral=True)

            return

        # Sauvegarder l'historique

        transcript = ""

        async for msg in interaction.channel.history(limit=None, oldest_first=True):

            author = msg.author

            content = msg.content

            transcript += f"{author}: {content}\n"

        # Envoyer le transcript au salon log

        log_channel = interaction.guild.get_channel(TICKET_LOG_CHANNEL_ID)

        if log_channel:

            file = discord.File(io.BytesIO(transcript.encode()), filename=f"{interaction.channel.name}_transcript.txt")

            await log_channel.send(

                content=f"📝 **Transcript du ticket** `{interaction.channel.name}`",

                file=file

            )

        # Supprimer le salon

        await interaction.channel.delete(reason="Ticket fermé")

        

class TicketView(discord.ui.View):

    def __init__(self):

        super().__init__(timeout=None)

    @discord.ui.button(label="📩 Ouvrir un ticket", style=discord.ButtonStyle.blurple)

    async def open_ticket(self, interaction: discord.Interaction, button: discord.ui.Button):

        guild = interaction.guild

        category = guild.get_channel(TICKET_CATEGORY_ID)

        if category is None or not isinstance(category, discord.CategoryChannel):

            await interaction.response.send_message("❌ Catégorie de ticket introuvable. Vérifiez la config.", ephemeral=True)

            return

        for channel in category.text_channels:

            if channel.topic == str(interaction.user.id):

                await interaction.response.send_message("❌ Vous avez déjà un ticket ouvert.", ephemeral=True)

                return

        overwrites = {

            guild.default_role: discord.PermissionOverwrite(view_channel=False),

            interaction.user: discord.PermissionOverwrite(view_channel=True, send_messages=True),

            guild.me: discord.PermissionOverwrite(view_channel=True, send_messages=True)

        }

        ticket_channel = await category.create_text_channel(

            name=f"ticket-{interaction.user.name}",

            topic=str(interaction.user.id),

            overwrites=overwrites

        )

        embed = discord.Embed(

            title="🎫 Ticket ouvert",

            description="Merci de décrire votre problème. Un membre du staff vous répondra bientôt.",

            color=discord.Color.green()

        )

        await ticket_channel.send(content=interaction.user.mention, embed=embed, view=CloseTicketView())

        await interaction.response.send_message(f"✅ Ticket créé : {ticket_channel.mention}", ephemeral=True)

class Ticket(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="ticket-setup", description="Configurer le message pour ouvrir un ticket")

    @app_commands.checks.has_permissions(administrator=True)

    async def ticket_setup(self, interaction: discord.Interaction):

        embed = discord.Embed(

            title="📩 Support",

            description="Cliquez sur le bouton ci-dessous pour ouvrir un ticket avec le staff.",

            color=discord.Color.blue()

        )

        await interaction.channel.send(embed=embed, view=TicketView())

        await interaction.response.send_message("✅ Message de ticket envoyé.", ephemeral=True)

async def setup(bot):

    await bot.add_cog(Ticket(bot))