import discord

from discord import app_commands

from discord.ext import commands

import json

with open("config.json") as f:

    config = json.load(f)

FOOTER_TEXT = config["FOOTER_TEXT"]

FOOTER_ICON = config["FOOTER_ICON"]

class Reunion(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="reunion", description="Annoncer une réunion")

    async def reunion(self, interaction: discord.Interaction, titre: str, date: str, heure: str, description: str):

        embed = discord.Embed(title=f"📢 Réunion : {titre}", color=0x2f3136)

        embed.add_field(name="Date", value=date, inline=True)

        embed.add_field(name="Heure", value=heure, inline=True)

        embed.add_field(name="Description", value=description.replace("\\n", "\n"), inline=False)

        embed.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

        await interaction.channel.send(embed=embed)

        await interaction.response.send_message("✅ Réunion annoncée.", ephemeral=True)

async def setup(bot):

    await bot.add_cog(Reunion(bot))