import discord

from discord import app_commands

from discord.ext import commands

import json

# Charger la config

with open("config.json") as f:

    config = json.load(f)

RDV_CHANNEL_ID = config["RDV_CHANNEL_ID"]

FOOTER_TEXT = config["FOOTER_TEXT"]

FOOTER_ICON = config["FOOTER_ICON"]

class RDVView(discord.ui.View):

    def __init__(self, demandeur, cible, dateheure):

        super().__init__(timeout=None)

        self.demandeur = demandeur

        self.cible = cible

        self.dateheure = dateheure

    @discord.ui.button(label="✅ Accepter", style=discord.ButtonStyle.green)

    async def accepter(self, interaction: discord.Interaction, button: discord.ui.Button):

        if interaction.user != self.cible:

            await interaction.response.send_message("❌ Vous n'êtes pas autorisé à répondre à ce rendez-vous.", ephemeral=True)

            return

        await interaction.message.delete()

        embed_accept = discord.Embed(

            title="📅 Rendez-vous Accepté !",

            description=f"{self.demandeur.mention}, votre rendez-vous avec {self.cible.mention} a été accepté. Merci de venir le **{self.dateheure}** dans la salle d'attente.",

            color=0x00FF00

        )

        embed_accept.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

        await interaction.channel.send(embed=embed_accept)

        await self.demandeur.send(f"✅ Votre rendez-vous avec {self.cible.display_name} a été accepté pour le {self.dateheure}.")

    @discord.ui.button(label="❌ Refuser", style=discord.ButtonStyle.red)

    async def refuser(self, interaction: discord.Interaction, button: discord.ui.Button):

        if interaction.user != self.cible:

            await interaction.response.send_message("❌ Vous n'êtes pas autorisé à répondre à ce rendez-vous.", ephemeral=True)

            return

        async def ask_reason():

            modal = ReasonModal(self.demandeur, self.cible)

            await interaction.response.send_modal(modal)

        await ask_reason()

class ReasonModal(discord.ui.Modal, title="Motif du refus"):

    motif = discord.ui.TextInput(label="Motif", style=discord.TextStyle.long, required=True)

    def __init__(self, demandeur, cible):

        super().__init__()

        self.demandeur = demandeur

        self.cible = cible

    async def on_submit(self, interaction: discord.Interaction):

        await self.demandeur.send(f"❌ Votre rendez-vous avec {self.cible.display_name} a été refusé.\n**Motif :** {self.motif.value}")

        embed_refuse = discord.Embed(

            title="📅 Rendez-vous Refusé !",

            description=f"{self.demandeur.mention}, votre rendez-vous avec {self.cible.mention} a été refusé.\nMerci de prendre un nouveau rendez-vous.",

            color=0xFF0000

        )

        embed_refuse.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

        await interaction.channel.send(embed=embed_refuse)

class RDV(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="rdv", description="Proposer un rendez-vous")

    async def rdv(self, interaction: discord.Interaction, cible: discord.Member, motif: str, dateheure: str):

        salon = self.bot.get_channel(RDV_CHANNEL_ID)

        if salon is None:

            await interaction.response.send_message("❌ Salon de rendez-vous introuvable. Vérifie l'ID.", ephemeral=True)

            return

        # 1️⃣ Ping la personne

        await salon.send(cible.mention)

        # 2️⃣ Embed avec infos

        embed = discord.Embed(title="📅 Nouvelle demande de RDV", color=0x2f3136)

        embed.add_field(name="Demandeur", value=interaction.user.mention, inline=False)

        embed.add_field(name="Destinataire", value=cible.mention, inline=False)

        embed.add_field(name="Motif", value=motif, inline=False)

        embed.add_field(name="Date & Heure", value=dateheure, inline=False)

        embed.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

        view = RDVView(interaction.user, cible, dateheure)

        msg = await salon.send(embed=embed, view=view)

        await interaction.response.send_message(f"✅ Demande envoyée dans {salon.mention}.", ephemeral=True)

async def setup(bot):

    await bot.add_cog(RDV(bot))