import discord

from discord import app_commands

from discord.ext import commands

class MPCommand(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="mp", description="Envoyer un message privé à un utilisateur")

    async def mp(self, interaction: discord.Interaction, utilisateur: discord.User, message: str):

        try:

            await utilisateur.send(message)

            await interaction.response.send_message(f"📩 Message envoyé à {utilisateur.mention}", ephemeral=True)

        except discord.Forbidden:

            await interaction.response.send_message("❌ Impossible d'envoyer un message à cet utilisateur.", ephemeral=True)

async def setup(bot):

    await bot.add_cog(MPCommand(bot))