import discord

from discord import app_commands

from discord.ext import commands

import json

with open("config.json") as f:

    config = json.load(f)

CONVOCATION_ROLE_ID = config["CONVOCATION_ROLE_ID"]

CONVOCATION_CHANNEL_ID = config["CONVOCATION_CHANNEL_ID"]

FOOTER_TEXT = config["FOOTER_TEXT"]

FOOTER_ICON = config["FOOTER_ICON"]

class Convocation(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="convocation", description="Envoyer une convocation (réservé au personnel)")

    async def convocation(self, interaction: discord.Interaction, cible: discord.Member, motif: str, date: str, heure: str):

        if CONVOCATION_ROLE_ID not in [role.id for role in interaction.user.roles]:

            await interaction.response.send_message("❌ Vous n'avez pas la permission d'utiliser cette commande.", ephemeral=True)

            return

        salon = self.bot.get_channel(CONVOCATION_CHANNEL_ID)

        if salon is None:

            await interaction.response.send_message("❌ Salon introuvable.", ephemeral=True)

            return

        message_mp = (

            f"Bonjour {cible.mention}, vous êtes convoqué par {interaction.user.mention} "

            f"pour le motif : **{motif}** le **{date}** à **{heure}**.\n\n"

            "Merci, l'administration de Charles De Gaulle."

        )

        try:

            await cible.send(message_mp)

        except discord.Forbidden:

            await interaction.response.send_message("❌ Impossible d'envoyer un MP à cette personne.", ephemeral=True)

            return

        embed = discord.Embed(title="📄 Convocation envoyée", color=0x2f3136)

        embed.add_field(name="Destinataire", value=cible.mention, inline=False)

        embed.add_field(name="Motif", value=motif, inline=False)

        embed.add_field(name="Date", value=date, inline=True)

        embed.add_field(name="Heure", value=heure, inline=True)

        embed.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

        await salon.send(embed=embed)

        await interaction.response.send_message(f"✅ Convocation envoyée à {cible.mention}.", ephemeral=True)

async def setup(bot):

    await bot.add_cog(Convocation(bot))